﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using TaleWorlds.MountAndBlade;

using HarmonyLib;
using System.Windows.Forms;

namespace DaytimeHideouts
{
	public class ExceptionHandler
	{
		public static string ToString(Exception ex)
		{
			return GetString(ex);
		}

		private static string GetString(Exception ex)
		{
			StringBuilder stringBuilder = new StringBuilder();

			GetStringRecursive(ex, stringBuilder);

			stringBuilder.AppendLine();
			stringBuilder.AppendLine("Stack trace: ");
			stringBuilder.AppendLine(ex.StackTrace);

			return stringBuilder.ToString();
		}

		private static void GetStringRecursive(Exception ex, StringBuilder sb)
		{
			sb.AppendLine(ex.GetType().Name + ": ");
			sb.AppendLine(ex.Message);
			if (ex.InnerException != null)
			{
				sb.AppendLine();
				GetStringRecursive(ex.InnerException, sb);
			}
		}
	}

	public class DaytimeHideoutsSubModule : MBSubModuleBase 
    {
        protected override void OnSubModuleLoad()
        {
            try
            {
                Harmony harmonyPatch = new Harmony("bannerlord.daytimehideouts");
                harmonyPatch.PatchAll();
            }
            catch(Exception ex)
            {
				MessageBox.Show("Failed hooking daytime hideout assault code\n\n" + ExceptionHandler.ToString(ex));
            }
        }
    }
}
